<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">C1RESTREALDEP</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="82.1%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                           </td>
                           <td width="17.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="82.1%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">EXECUTION DU BUDGET – RAR DEPENSES</span></b></p>
                              
                           </td>
                           <td width="17.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">C1</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="margin-top:0in;margin-right:46.45pt;margin-bottom: 0in;margin-left:7.1pt;margin-bottom:.0001pt;text-align:justify"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">DETAIL DES RESTES A REALISER N EN DEPENSES (1)</span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='D') and (not(./n:Fonction/@V))                         and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0)]"/>
                        <thead>
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="50.2%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="-46.1%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="82.5%" style="border:none" rowspan="1" colspan="1"/>
                           </tr>
                           
                           <tr style="page-break-inside:avoid">
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Chap. / art. (2)</span></b></p>
                                 
                              </td>
                              <td width="50.2%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Libellé</span></b></p>
                                 
                              </td>
                              <td width="36.4%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Dépenses engagées non mandatées</span></b></p>
                                 
                              </td>
                           </tr>
                           
                        </thead>
                        <tr style="page-break-inside:avoid">
                           <td width="13.4%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              <p class="MsoNormal" style="margin-right:11.95pt;text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">SECTION D’INVESTISSEMENT – TOTAL</span></b></p>
                              
                           </td>
                           <td width="4.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">(I)</span></p>
                              
                           </td>
                           <td width="32.3%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINV')]/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='018') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">018</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '018' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm3">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='018' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='018')]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm4">
                           <xsl:choose>
                              <xsl:when test="count($varOdm3/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm3"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='10') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">10</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm6">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='10' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm7">
                           <xsl:choose>
                              <xsl:when test="count($varOdm6/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm6"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm7/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='13') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">13</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm9">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='13' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm10">
                           <xsl:choose>
                              <xsl:when test="count($varOdm9/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm9"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm10/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='16') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">16</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm12">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='16' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm13">
                           <xsl:choose>
                              <xsl:when test="count($varOdm12/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm12"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm13/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='18') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">18</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm15">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='18' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm16">
                           <xsl:choose>
                              <xsl:when test="count($varOdm15/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm15"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm16/xhtml:tr"/>
                        </xsl:call-template>
                        <xsl:variable name="varOdm17">
                           <xsl:for-each select="distinct-values($varOdm1[(./n:Nature/@V) and (./n:Operation/@V) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]/n:Operation/@V)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm1[(./n:Operation/@V=$codeBoucle) and (./n:Nature/@V) and (./n:Operation/@V) and                               (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></b></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Opération d’équipement n° <xsl:value-of select="distinct-values($codeBoucle)"/></span></b></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm18">
                           <xsl:choose>
                              <xsl:when test="count($varOdm17/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm17"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"/>
                           <xsl:with-param name="rows" select="$varOdm18/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm19" select="$varOdm1[(n:ChapitreNature/@V='20') and (./n:InfoOpe/@V='TNULL')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">20</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"/> (sauf le 204) (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm19/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm20">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='20' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))                               and (not(./n:Operation/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm21">
                           <xsl:choose>
                              <xsl:when test="count($varOdm20/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm20"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm21/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm22" select="$varOdm1[(n:ChapitreNature/@V='204') and (./n:InfoOpe/@V='TNULL')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">204</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm22/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm23">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='204' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))                               and (not(./n:Operation/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm24">
                           <xsl:choose>
                              <xsl:when test="count($varOdm23/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm23"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm24/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm25" select="$varOdm1[(n:ChapitreNature/@V='21') and (./n:InfoOpe/@V='TNULL')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">21</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm25/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm26">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='21' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))                               and (not(./n:Operation/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm27">
                           <xsl:choose>
                              <xsl:when test="count($varOdm26/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm26"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm27/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm28" select="$varOdm1[(n:ChapitreNature/@V='22') and (./n:InfoOpe/@V='TNULL')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">22</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"> <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm28/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm29">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='22' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))                               and (not(./n:Operation/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm30">
                           <xsl:choose>
                              <xsl:when test="count($varOdm29/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm29"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm30/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm31" select="$varOdm1[(n:ChapitreNature/@V='23') and (./n:InfoOpe/@V='TNULL')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">23</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm31/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm32">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='23' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))                               and (not(./n:Operation/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm33">
                           <xsl:choose>
                              <xsl:when test="count($varOdm32/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm32"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm33/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm34" select="$varOdm1[(n:ChapitreNature/@V='26') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">26</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm34/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm35">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='26' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm36">
                           <xsl:choose>
                              <xsl:when test="count($varOdm35/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm35"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm36/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm37" select="$varOdm1[(n:ChapitreNature/@V='27') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">27</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm37/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm38">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='27' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm39">
                           <xsl:choose>
                              <xsl:when test="count($varOdm38/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm38"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm39/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid">
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">45</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Chapitres d’opérations pour compte de tiers</span></b></p>
                              
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPOPCT')                                        and (./n:OpBudg/@V='0')]/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm40">
                           <xsl:for-each select="distinct-values($varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V)]/n:TypNumCpteTiers/@V)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V) and (./n:TypNumCpteTiers/@V=$codeBoucle)]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:Nature/@V)"/><xsl:value-of select="distinct-values($ligne/n:OpeCpteTiers/@V)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:LibCpte/@V)"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm41">
                           <xsl:choose>
                              <xsl:when test="count($varOdm40/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm40"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"/>
                           <xsl:with-param name="rows" select="$varOdm41/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid">
                           <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="margin-right:46.45pt;text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">SECTION DE FONCTIONNEMENT – TOTAL</span></b></p>
                              
                           </td>
                           <td width="4.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">(II)</span></p>
                              
                           </td>
                           <td width="32.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm42" select="$varOdm1[(n:ChapitreNature/@V='011') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">011</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '011' and @Type = 'C']/@LibelleCourt)[1])"/> (4)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm42/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm43">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='011' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm44">
                           <xsl:choose>
                              <xsl:when test="count($varOdm43/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm43"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm44/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm45" select="$varOdm1[(n:ChapitreNature/@V='012') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">012</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '012' and @Type = 'C']/@LibelleCourt)[1])"/> (4)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm45/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm46">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='012' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm47">
                           <xsl:choose>
                              <xsl:when test="count($varOdm46/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm46"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm47/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm48" select="$varOdm1[(n:ChapitreNature/@V='014') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">014</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '014' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm48/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm49">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='014' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm50">
                           <xsl:choose>
                              <xsl:when test="count($varOdm49/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm49"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm50/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm51" select="$varOdm1[(n:ChapitreNature/@V='016') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">016</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '016' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm51/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm52">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='016' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='016')]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm53">
                           <xsl:choose>
                              <xsl:when test="count($varOdm52/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm52"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm53/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm54" select="$varOdm1[(n:ChapitreNature/@V='017') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">017</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '017' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm54/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm55">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='017' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='017')]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm56">
                           <xsl:choose>
                              <xsl:when test="count($varOdm55/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm55"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm56/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm57" select="$varOdm1[(n:ChapitreNature/@V='65') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">65</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '65' and @Type = 'C']/@LibelleCourt)[1])"/> (4)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm57/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm58">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='65' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm59">
                           <xsl:choose>
                              <xsl:when test="count($varOdm58/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm58"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm59/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm60" select="$varOdm1[(n:ChapitreNature/@V='6586') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">6586</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '6586' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm60/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm61">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='6586' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm62">
                           <xsl:choose>
                              <xsl:when test="count($varOdm61/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm61"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm62/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm63" select="$varOdm1[(n:ChapitreNature/@V='66') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">66</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <h3 align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '66' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></h3>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm63/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm64">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='66' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm65">
                           <xsl:choose>
                              <xsl:when test="count($varOdm64/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm64"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm65/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid"><xsl:variable name="varOdm66" select="$varOdm1[(n:ChapitreNature/@V='67') and (./n:InfoOpe/@V='T')]"/>
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">67</span></b></p>
                              
                           </td>
                           <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '67' and @Type = 'C']/@LibelleCourt)[1])"/> (4)</span></b></p>
                           </td>
                           <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm66/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <xsl:variable name="varOdm67">
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='67' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              <xsl:sort select="."/>
                              <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='D')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                              <xsl:if test="$ligne">
                                 <tr style="page-break-inside:avoid">
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                    </td>
                                    <td width="50.2%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                    </td>
                                    <td width="36.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm68">
                           <xsl:choose>
                              <xsl:when test="count($varOdm67/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="50.2%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"/>
                                    <td height="1px" width="36.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm67"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm68/xhtml:tr"/>
                        </xsl:call-template>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="margin-right:46.45pt;text-align:justify"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Il s’agit des restes à réaliser établis conformément à la comptabilité d’engagement annuelle. Ces restes à réaliser seront
                     repris au BP ou au BS N+1.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) Suivant le niveau de vote retenu par l’assemblée délibérante.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) Hors dépenses imputées au chapitre 018.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(4) Hors dépenses imputées aux chapitres 016 et 017.</span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>